#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_VbecsVistAUser : BaseTest 
	{
		private VbecsVistAUser _testUser;
		private static IEnumerator _testUserEn;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			VistALinkUnitTestHarness.RequireConnection();
			
			_testUser = GetFreshVbecsVistaUserInstance();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 

			_testUser = null;
		}

		// Using this tricky way to speed up unit tests.
		// The member gets a list of VistA users only once and then 
		// loops through it refreshing the list if necessary.
		private static VbecsVistAUser GetFreshVbecsVistaUserInstance()
		{
			if( _testUserEn == null || !_testUserEn.MoveNext() )
			{				
				_testUserEn = VbecsVistAUser.GetAllVistAUsersHashedByDuz().Values.GetEnumerator();
				_testUserEn.MoveNext();
			}

			if( _testUserEn.Current == null )
				Assert.Fail( "No users were found in VistA" );
			
			return (VbecsVistAUser)_testUserEn.Current;
		}

		[Test]
		public void GetAllVistAUsersHashedByDuz_Pass_1()
		{
			Assert.IsNotNull( VbecsVistAUser.GetAllVistAUsersHashedByDuz() );
		}

		[Test]
		public void GetAllVistAUsersHashedByDuz_Pass_2()
		{
			Assert.IsTrue( VbecsVistAUser.GetAllVistAUsersHashedByDuz().Keys.Count > 0 );
		}

		[Test]
		[ExpectedException( typeof( DAL.VistALink.Client.VistALinkClientRPCException   ) )]
		public void GetAllVistAUsersHashedByDuz_Fail()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();
			VbecsVistAUser.GetAllVistAUsersHashedByDuz();
		}

		[Test]
		public void Duz_Pass()
		{
			Assert.IsNotNull( _testUser.Duz );
			Assert.IsTrue( _testUser.Duz.Length > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void Duz_Fail() {}

		[Test]
		public void UserName_Pass()
		{
			Assert.IsNotNull( _testUser.Duz );
			Assert.IsTrue( _testUser.UserName.Length > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void UserName_Fail() {}

		[Test]
		public void Initials_Pass()
		{
			Assert.IsTrue( _testUser.Initials == null || _testUser.Initials.Length <= 3 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void Initials_Fail() {}

		[Test]
		public void AvailableDivisionsHashedByCode_Pass()
		{
			Assert.IsNotNull( _testUser.AvailableDivisionsHashedByCode );
			Assert.IsTrue( _testUser.AvailableDivisionsHashedByCode.Count > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void AvailableDivisionsHashedByCode_Fail() {}
	}
}

#endif
